/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.common;

import ibm.nways.jdm.common.Hex;
import ibm.nways.jdm.snmp.SnmpV1API;
import ibm.nways.jdm.snmp.Translate;
import java.io.Serializable;

public class OctetString
implements Serializable {
    private static byte[] convert;
    public byte[] value;

    public OctetString(String string) {
        this(string, false);
    }

    public OctetString(String string, boolean bl) {
        if (bl) {
            this.value = string.getBytes();
            if (SnmpV1API.useEBCDIC) {
                int n = 0;
                while (n < this.value.length) {
                    this.value[n] = Translate.toAscii((byte)this.value[n]);
                    ++n;
                }
                return;
            }
        } else {
            int n = 0;
            if (string != null) {
                int n2;
                byte[] byArray;
                String string2 = string;
                if (string.length() % 2 != 0) {
                    string2 = String.valueOf(string) + "0";
                }
                if (SnmpV1API.useEBCDIC) {
                    byArray = string2.getBytes();
                    n2 = 0;
                    while (n2 < byArray.length) {
                        byArray[n2] = Translate.toAscii((byte)byArray[n2]);
                        ++n2;
                    }
                } else {
                    byArray = string2.getBytes();
                }
                this.value = new byte[string2.length() / 2];
                n2 = 0;
                while (n2 < string2.length()) {
                    this.value[n++] = (byte)(convert[byArray[n2]] << 4 | convert[byArray[n2 + 1]]);
                    n2 += 2;
                }
            }
        }
    }

    public OctetString(byte[] byArray) {
        this.value = byArray;
    }

    public OctetString(OctetString octetString) {
        this.value = new byte[octetString.value.length];
        int n = 0;
        while (n < this.value.length) {
            this.value[n] = octetString.value[n];
            ++n;
        }
    }

    public OctetString(byte[] byArray, int n, int n2) {
        this.value = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.value[n3] = byArray[n++];
            ++n3;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof OctetString) {
            OctetString octetString = (OctetString)object;
            boolean bl = true;
            if (this.value.length == octetString.value.length) {
                int n = 0;
                while (bl && n < this.value.length) {
                    bl = this.value[n] == octetString.value[n];
                    ++n;
                }
            } else {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public String toString() {
        return Hex.toString(this.value);
    }

    public String toDisplayString() {
        if (SnmpV1API.useEBCDIC) {
            byte[] byArray = new byte[this.value.length];
            int n = 0;
            while (n < this.value.length) {
                byArray[n] = Translate.toEbcdic((byte)this.value[n]);
                ++n;
            }
            return new String(byArray, 0, byArray.length);
        }
        return new String(this.value, 0, this.value.length);
    }

    public boolean isDisplayString() {
        int n = 0;
        while (n < this.value.length) {
            if (!(this.value[n] >= 97 && this.value[n] <= 122 || this.value[n] >= 65 && this.value[n] <= 90 || this.value[n] >= 48 && this.value[n] <= 57 || this.value[n] == 45 || this.value[n] == 95 || this.value[n] == 43 || this.value[n] == 61 || this.value[n] == 32 || this.value[n] == 9 || this.value[n] == 10 || this.value[n] == 60 || this.value[n] == 62 || this.value[n] == 47 || this.value[n] == 63 || this.value[n] == 46 || this.value[n] == 44 || this.value[n] == 33 || this.value[n] == 64 || this.value[n] == 35 || this.value[n] == 36 || this.value[n] == 37 || this.value[n] == 94 || this.value[n] == 38 || this.value[n] == 42 || this.value[n] == 40 || this.value[n] == 41)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    static {
        byte[] byArray = new byte[256];
        byArray[49] = 1;
        byArray[50] = 2;
        byArray[51] = 3;
        byArray[52] = 4;
        byArray[53] = 5;
        byArray[54] = 6;
        byArray[55] = 7;
        byArray[56] = 8;
        byArray[57] = 9;
        byArray[65] = 10;
        byArray[66] = 11;
        byArray[67] = 12;
        byArray[68] = 13;
        byArray[69] = 14;
        byArray[70] = 15;
        byArray[97] = 10;
        byArray[98] = 11;
        byArray[99] = 12;
        byArray[100] = 13;
        byArray[101] = 14;
        byArray[102] = 15;
        convert = byArray;
    }
}

